#region References

using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;

#endregion

namespace gov.va.med.vbecs.GUI
{
	#region Header

	//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	//<Developers>
	//	<Developer>Margaret Jablonski</Developer>
	//</Developers>
	//<SiteName>Hines OIFO</SiteName>
	//<CreationDate>6/8/2004</CreationDate>
	//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	//<summary></summary>

	#endregion

	/// <summary>
	/// Class FrmReturnIssuedUnits
	/// </summary>
	public class FrmReturnIssuedUnits : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		private const string FORM_NAME = "Return Issued Units";
		/// <summary>
		///  Indicates if user is comming from Blood Unit or Patient menu   
		/// </summary>
		private bool _fromBloodUnitMenu;

		/// <summary>
		/// Is form loading
		/// </summary>
		private bool _isLoading = false;

		/// <summary>
		/// Name of the person that returned the unit
		/// </summary>
		private string _returnTechId;

		/// <summary>
		/// Date and time that the unit was returned
		/// </summary>
		private DateTime _returnDateTime;

		/// <summary>
		/// List of all units in Issued status
		/// </summary>
		private System.Collections.ArrayList _issuedUnits;

		/// <summary>
		/// Arraylist of units selected for return
		/// </summary>
		private System.Collections.ArrayList _returnUnitsList;

		/// <summary>
		/// Current working Issued Unit object
		/// </summary>
		private BOL.IssuedUnit _currentIssuedUnit;
		private System.Guid [] _bloodUnitGuids = null;
		private DataRow[] _issuedUnitsData = null;

		private Common.WorkloadProcessID _workloadProcessId = Common.WorkloadProcessID.ReturnIssuedUnit;

		#endregion

		#region Form Controls

		private System.Windows.Forms.Panel pnlReturnUnits;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ContextMenu mnuInspection;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.Label lblReturnDate;
		private System.Windows.Forms.Label lblReturnBy;
		private System.Windows.Forms.GroupBox grpReturnInfo;
		private System.Windows.Forms.GroupBox groupBox2;
		private gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab bloodUnitDetailsTab1;
		private System.Windows.Forms.GroupBox grpUnitIssueDetails;
		private System.Windows.Forms.GroupBox grpRemoteStorage;
		private System.Windows.Forms.TextBox txtRemoteStrorage;
		private System.Windows.Forms.Label lblRemoteStorage;
		private System.Windows.Forms.TextBox txtLocationName;
		private System.Windows.Forms.TextBox txtTransporter;
		private System.Windows.Forms.TextBox txtIssueDate;
		private System.Windows.Forms.Label lblLocationName;
		private System.Windows.Forms.Label lblIssueDate;
		private System.Windows.Forms.Label lblTransporter;
		private System.Windows.Forms.GroupBox grpUnitReturnDetails;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbReturnFromLocation;
		private System.Windows.Forms.Label lblReturnFromLocation;
		private System.Windows.Forms.GroupBox grpSelectUnits;
		private System.Windows.Forms.ListView lvUnitsReturned;
		private System.Windows.Forms.Panel pnlIssueUnits;
		private gov.va.med.vbecs.GUI.controls.PatientDisplayPanel patientDisplayPanel1;
		private gov.va.med.vbecs.GUI.controls.PatientSelectTool patientSelectTool1;
		private System.Windows.Forms.CheckBox cbUnsatisfactory;
		private System.Windows.Forms.TextBox txtReturnBy;
		private System.Windows.Forms.TextBox txtReturnDate;
		private gov.va.med.vbecs.GUI.controls.WorklistBuilder worklistBuilder1;
		private System.Windows.Forms.ImageList imageList1;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="returnDateTime"></param>
		/// <param name="returnTechId"></param>
		/// <param name="fromBloodUnitMenu"></param>
		public FrmReturnIssuedUnits(DateTime returnDateTime, string returnTechId, bool fromBloodUnitMenu)
		{
			this.LockController.LockFunction = Common.LockFunctions.UC059ReturnIssuedUnits;

			this._isLoading = true;
			
			//Get parameters data
			this._returnTechId = returnTechId;
			//Displaying BR_59.02 The same return date is applied to all units
			this._returnDateTime = returnDateTime;
			this._fromBloodUnitMenu = fromBloodUnitMenu;
			
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			SetComponentProperties();

			if(this._fromBloodUnitMenu)
			{
				this.SetUnitControlData();
			}
			else
			{
				this.SetPatientControlData();
			}

            //CR 3303
            this.lvUnitsReturned.ShowItemToolTips = true;

			this._isLoading = false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmReturnIssuedUnits));
            this.pnlReturnUnits = new System.Windows.Forms.Panel();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.bloodUnitDetailsTab1 = new gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab();
            this.grpUnitIssueDetails = new System.Windows.Forms.GroupBox();
            this.grpRemoteStorage = new System.Windows.Forms.GroupBox();
            this.txtRemoteStrorage = new System.Windows.Forms.TextBox();
            this.lblRemoteStorage = new System.Windows.Forms.Label();
            this.txtLocationName = new System.Windows.Forms.TextBox();
            this.txtTransporter = new System.Windows.Forms.TextBox();
            this.txtIssueDate = new System.Windows.Forms.TextBox();
            this.lblLocationName = new System.Windows.Forms.Label();
            this.lblIssueDate = new System.Windows.Forms.Label();
            this.lblTransporter = new System.Windows.Forms.Label();
            this.grpUnitReturnDetails = new System.Windows.Forms.GroupBox();
            this.cmbReturnFromLocation = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblReturnFromLocation = new System.Windows.Forms.Label();
            this.cbUnsatisfactory = new System.Windows.Forms.CheckBox();
            this.grpSelectUnits = new System.Windows.Forms.GroupBox();
            this.lvUnitsReturned = new System.Windows.Forms.ListView();
            this.columnHeader1 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader3 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader4 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader5 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader6 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.mnuInspection = new System.Windows.Forms.ContextMenu();
            this.menuItem1 = new System.Windows.Forms.MenuItem();
            this.menuItem2 = new System.Windows.Forms.MenuItem();
            this.imageList1 = new System.Windows.Forms.ImageList(this.components);
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.picImage = new System.Windows.Forms.PictureBox();
            this.grpReturnInfo = new System.Windows.Forms.GroupBox();
            this.txtReturnBy = new System.Windows.Forms.TextBox();
            this.txtReturnDate = new System.Windows.Forms.TextBox();
            this.lblReturnDate = new System.Windows.Forms.Label();
            this.lblReturnBy = new System.Windows.Forms.Label();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnCancel = new System.Windows.Forms.Button();
            this.pnlIssueUnits = new System.Windows.Forms.Panel();
            this.patientDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.PatientDisplayPanel();
            this.patientSelectTool1 = new gov.va.med.vbecs.GUI.controls.PatientSelectTool();
            this.worklistBuilder1 = new gov.va.med.vbecs.GUI.controls.WorklistBuilder(this.components);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.pnlReturnUnits.SuspendLayout();
            this.groupBox2.SuspendLayout();
            this.grpUnitIssueDetails.SuspendLayout();
            this.grpRemoteStorage.SuspendLayout();
            this.grpUnitReturnDetails.SuspendLayout();
            this.grpSelectUnits.SuspendLayout();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).BeginInit();
            this.grpReturnInfo.SuspendLayout();
            this.pnlIssueUnits.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(742, 30);
            this.vbecsLogo1.TabIndex = 4;
            this.vbecsLogo1.Title = "Return Issued Units";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 509);
            this.lblRequiredField.TabIndex = 5;
            // 
            // pnlReturnUnits
            // 
            this.pnlReturnUnits.Controls.Add(this.groupBox2);
            this.pnlReturnUnits.Controls.Add(this.grpSelectUnits);
            this.pnlReturnUnits.Controls.Add(this.grpImage);
            this.pnlReturnUnits.Controls.Add(this.grpReturnInfo);
            this.pnlReturnUnits.Dock = System.Windows.Forms.DockStyle.Fill;
            this.pnlReturnUnits.Location = new System.Drawing.Point(0, 44);
            this.pnlReturnUnits.Name = "pnlReturnUnits";
            this.pnlReturnUnits.Size = new System.Drawing.Size(736, 416);
            this.pnlReturnUnits.TabIndex = 1;
            // 
            // groupBox2
            // 
            this.groupBox2.AccessibleDescription = "Selected Unit";
            this.groupBox2.AccessibleName = "Selected Unit";
            this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.groupBox2.Controls.Add(this.bloodUnitDetailsTab1);
            this.groupBox2.Controls.Add(this.grpUnitIssueDetails);
            this.groupBox2.Controls.Add(this.grpUnitReturnDetails);
            this.groupBox2.Location = new System.Drawing.Point(436, 36);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(300, 380);
            this.groupBox2.TabIndex = 5;
            this.groupBox2.TabStop = false;
            this.groupBox2.Text = "Selected Unit";
            // 
            // bloodUnitDetailsTab1
            // 
            this.bloodUnitDetailsTab1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.bloodUnitDetailsTab1.BloodUnit = null;
            this.bloodUnitDetailsTab1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.bloodUnitDetailsTab1.Location = new System.Drawing.Point(8, 16);
            this.bloodUnitDetailsTab1.Name = "bloodUnitDetailsTab1";
            this.bloodUnitDetailsTab1.Size = new System.Drawing.Size(284, 132);
            this.bloodUnitDetailsTab1.TabIndex = 6;
            // 
            // grpUnitIssueDetails
            // 
            this.grpUnitIssueDetails.AccessibleDescription = "Unit Issue Details";
            this.grpUnitIssueDetails.AccessibleName = "Unit Issue Details";
            this.grpUnitIssueDetails.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpUnitIssueDetails.Controls.Add(this.grpRemoteStorage);
            this.grpUnitIssueDetails.Controls.Add(this.txtLocationName);
            this.grpUnitIssueDetails.Controls.Add(this.txtTransporter);
            this.grpUnitIssueDetails.Controls.Add(this.txtIssueDate);
            this.grpUnitIssueDetails.Controls.Add(this.lblLocationName);
            this.grpUnitIssueDetails.Controls.Add(this.lblIssueDate);
            this.grpUnitIssueDetails.Controls.Add(this.lblTransporter);
            this.grpUnitIssueDetails.Location = new System.Drawing.Point(8, 152);
            this.grpUnitIssueDetails.Name = "grpUnitIssueDetails";
            this.grpUnitIssueDetails.Size = new System.Drawing.Size(284, 148);
            this.grpUnitIssueDetails.TabIndex = 7;
            this.grpUnitIssueDetails.TabStop = false;
            this.grpUnitIssueDetails.Text = "Unit Issue Details";
            // 
            // grpRemoteStorage
            // 
            this.grpRemoteStorage.AccessibleDescription = "Remote Storage Location";
            this.grpRemoteStorage.AccessibleName = "Remote Storage Location";
            this.grpRemoteStorage.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpRemoteStorage.Controls.Add(this.txtRemoteStrorage);
            this.grpRemoteStorage.Controls.Add(this.lblRemoteStorage);
            this.grpRemoteStorage.Location = new System.Drawing.Point(8, 92);
            this.grpRemoteStorage.Name = "grpRemoteStorage";
            this.grpRemoteStorage.Size = new System.Drawing.Size(268, 48);
            this.grpRemoteStorage.TabIndex = 11;
            this.grpRemoteStorage.TabStop = false;
            this.grpRemoteStorage.Text = "Remote Storage Location";
            // 
            // txtRemoteStrorage
            // 
            this.txtRemoteStrorage.AccessibleDescription = "Identify";
            this.txtRemoteStrorage.AccessibleName = "Identify";
            this.txtRemoteStrorage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtRemoteStrorage.Location = new System.Drawing.Point(80, 20);
            this.txtRemoteStrorage.Name = "txtRemoteStrorage";
            this.txtRemoteStrorage.ReadOnly = true;
            this.txtRemoteStrorage.Size = new System.Drawing.Size(180, 20);
            this.txtRemoteStrorage.TabIndex = 12;
            // 
            // lblRemoteStorage
            // 
            this.lblRemoteStorage.Location = new System.Drawing.Point(8, 20);
            this.lblRemoteStorage.Name = "lblRemoteStorage";
            this.lblRemoteStorage.Size = new System.Drawing.Size(100, 20);
            this.lblRemoteStorage.TabIndex = 0;
            this.lblRemoteStorage.Text = "Identity";
            this.lblRemoteStorage.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtLocationName
            // 
            this.txtLocationName.AccessibleDescription = "Issued To";
            this.txtLocationName.AccessibleName = "Issued To";
            this.txtLocationName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtLocationName.Location = new System.Drawing.Point(88, 68);
            this.txtLocationName.Name = "txtLocationName";
            this.txtLocationName.ReadOnly = true;
            this.txtLocationName.Size = new System.Drawing.Size(184, 20);
            this.txtLocationName.TabIndex = 10;
            // 
            // txtTransporter
            // 
            this.txtTransporter.AccessibleDescription = "Transporter";
            this.txtTransporter.AccessibleName = "Transporter";
            this.txtTransporter.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtTransporter.Location = new System.Drawing.Point(88, 44);
            this.txtTransporter.Name = "txtTransporter";
            this.txtTransporter.ReadOnly = true;
            this.txtTransporter.Size = new System.Drawing.Size(184, 20);
            this.txtTransporter.TabIndex = 9;
            // 
            // txtIssueDate
            // 
            this.txtIssueDate.AccessibleDescription = "Issue Date";
            this.txtIssueDate.AccessibleName = "Issue Date";
            this.txtIssueDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtIssueDate.Location = new System.Drawing.Point(88, 20);
            this.txtIssueDate.Name = "txtIssueDate";
            this.txtIssueDate.ReadOnly = true;
            this.txtIssueDate.Size = new System.Drawing.Size(184, 20);
            this.txtIssueDate.TabIndex = 8;
            // 
            // lblLocationName
            // 
            this.lblLocationName.Location = new System.Drawing.Point(16, 68);
            this.lblLocationName.Name = "lblLocationName";
            this.lblLocationName.Size = new System.Drawing.Size(68, 20);
            this.lblLocationName.TabIndex = 4;
            this.lblLocationName.Text = "Issued To";
            this.lblLocationName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblIssueDate
            // 
            this.lblIssueDate.Location = new System.Drawing.Point(16, 20);
            this.lblIssueDate.Name = "lblIssueDate";
            this.lblIssueDate.Size = new System.Drawing.Size(64, 20);
            this.lblIssueDate.TabIndex = 0;
            this.lblIssueDate.Text = "Issue Date";
            this.lblIssueDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblTransporter
            // 
            this.lblTransporter.Location = new System.Drawing.Point(16, 44);
            this.lblTransporter.Name = "lblTransporter";
            this.lblTransporter.Size = new System.Drawing.Size(64, 20);
            this.lblTransporter.TabIndex = 2;
            this.lblTransporter.Text = "Transporter";
            this.lblTransporter.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpUnitReturnDetails
            // 
            this.grpUnitReturnDetails.AccessibleDescription = "Unit Return Details";
            this.grpUnitReturnDetails.AccessibleName = "Unit Return Details";
            this.grpUnitReturnDetails.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpUnitReturnDetails.Controls.Add(this.cmbReturnFromLocation);
            this.grpUnitReturnDetails.Controls.Add(this.lblReturnFromLocation);
            this.grpUnitReturnDetails.Controls.Add(this.cbUnsatisfactory);
            this.grpUnitReturnDetails.Location = new System.Drawing.Point(8, 304);
            this.grpUnitReturnDetails.Name = "grpUnitReturnDetails";
            this.grpUnitReturnDetails.Size = new System.Drawing.Size(284, 68);
            this.grpUnitReturnDetails.TabIndex = 13;
            this.grpUnitReturnDetails.TabStop = false;
            this.grpUnitReturnDetails.Text = "Unit Return Details";
            // 
            // cmbReturnFromLocation
            // 
            this.cmbReturnFromLocation.AccessibleDescription = "Returned From";
            this.cmbReturnFromLocation.AccessibleName = "Returned From";
            this.cmbReturnFromLocation.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbReturnFromLocation.Enabled = false;
            this.cmbReturnFromLocation.Interval = 1;
            this.cmbReturnFromLocation.Location = new System.Drawing.Point(88, 20);
            this.cmbReturnFromLocation.Name = "cmbReturnFromLocation";
            this.cmbReturnFromLocation.Size = new System.Drawing.Size(184, 22);
            this.cmbReturnFromLocation.TabIndex = 14;
            this.cmbReturnFromLocation.SelectedValueChanged += new System.EventHandler(this.cmbReturnFromLocation_SelectedValueChanged);
            this.cmbReturnFromLocation.Leave += new System.EventHandler(this.cmbReturnFromLocation_Leave);
            // 
            // lblReturnFromLocation
            // 
            this.lblReturnFromLocation.Location = new System.Drawing.Point(8, 20);
            this.lblReturnFromLocation.Name = "lblReturnFromLocation";
            this.lblReturnFromLocation.Size = new System.Drawing.Size(88, 20);
            this.lblReturnFromLocation.TabIndex = 0;
            this.lblReturnFromLocation.Text = "Returned From*";
            this.lblReturnFromLocation.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // cbUnsatisfactory
            // 
            this.cbUnsatisfactory.AccessibleDescription = "Unit Satisfactory for Return";
            this.cbUnsatisfactory.AccessibleName = "Unit Satisfactory for Return";
            this.cbUnsatisfactory.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cbUnsatisfactory.Enabled = false;
            this.cbUnsatisfactory.Location = new System.Drawing.Point(88, 44);
            this.cbUnsatisfactory.Name = "cbUnsatisfactory";
            this.cbUnsatisfactory.Size = new System.Drawing.Size(184, 20);
            this.cbUnsatisfactory.TabIndex = 15;
            this.cbUnsatisfactory.Text = "Unit &Unsatisfactory for Return";
            this.cbUnsatisfactory.CheckedChanged += new System.EventHandler(this.cbUnsatisfactory_CheckedChanged);
            // 
            // grpSelectUnits
            // 
            this.grpSelectUnits.AccessibleDescription = "Select Units to Return";
            this.grpSelectUnits.AccessibleName = "Select Units to Return";
            this.grpSelectUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSelectUnits.Controls.Add(this.lvUnitsReturned);
            this.grpSelectUnits.Location = new System.Drawing.Point(44, 36);
            this.grpSelectUnits.Name = "grpSelectUnits";
            this.grpSelectUnits.Size = new System.Drawing.Size(388, 380);
            this.grpSelectUnits.TabIndex = 3;
            this.grpSelectUnits.TabStop = false;
            this.grpSelectUnits.Text = "Select Units to Return";
            // 
            // lvUnitsReturned
            // 
            this.lvUnitsReturned.AccessibleDescription = "Select Units to Return";
            this.lvUnitsReturned.AccessibleName = "Select Units to Return";
            this.lvUnitsReturned.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvUnitsReturned.CheckBoxes = true;
            this.lvUnitsReturned.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2,
            this.columnHeader3,
            this.columnHeader4,
            this.columnHeader5,
            this.columnHeader6});
            this.lvUnitsReturned.ContextMenu = this.mnuInspection;
            this.lvUnitsReturned.FullRowSelect = true;
            this.lvUnitsReturned.HideSelection = false;
            this.lvUnitsReturned.Location = new System.Drawing.Point(8, 16);
            this.lvUnitsReturned.MultiSelect = false;
            this.lvUnitsReturned.Name = "lvUnitsReturned";
            this.lvUnitsReturned.Size = new System.Drawing.Size(372, 358);
            this.lvUnitsReturned.SmallImageList = this.imageList1;
            this.lvUnitsReturned.TabIndex = 4;
            this.lvUnitsReturned.UseCompatibleStateImageBehavior = false;
            this.lvUnitsReturned.View = System.Windows.Forms.View.Details;
            this.lvUnitsReturned.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvUnitsReturned_ColumnClick);
            this.lvUnitsReturned.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvUnitsReturned_ItemCheck);
            this.lvUnitsReturned.SelectedIndexChanged += new System.EventHandler(this.lvUnitsReturned_SelectedIndexChanged);
            this.lvUnitsReturned.MouseMove += new System.Windows.Forms.MouseEventHandler(this.lvUnitsReturned_MouseMove);
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "Return?";
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "Unit ID";
            // 
            // columnHeader3
            // 
            this.columnHeader3.Text = "Product";
            // 
            // columnHeader4
            // 
            this.columnHeader4.Text = "ABO/Rh";
            // 
            // columnHeader5
            // 
            this.columnHeader5.Text = "Expires";
            // 
            // columnHeader6
            // 
            this.columnHeader6.Text = "Return From";
            this.columnHeader6.Width = 90;
            // 
            // mnuInspection
            // 
            this.mnuInspection.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.menuItem1,
            this.menuItem2});
            // 
            // menuItem1
            // 
            this.menuItem1.Index = 0;
            this.menuItem1.Text = "&Satisfactory";
            // 
            // menuItem2
            // 
            this.menuItem2.Index = 1;
            this.menuItem2.Text = "&Unsatisfactory";
            // 
            // imageList1
            // 
            this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
            this.imageList1.TransparentColor = System.Drawing.Color.Transparent;
            this.imageList1.Images.SetKeyName(0, "");
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.picImage);
            this.grpImage.Location = new System.Drawing.Point(0, -4);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(40, 420);
            this.grpImage.TabIndex = 0;
            this.grpImage.TabStop = false;
            // 
            // picImage
            // 
            this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
            this.picImage.Location = new System.Drawing.Point(4, 12);
            this.picImage.Name = "picImage";
            this.picImage.Size = new System.Drawing.Size(32, 32);
            this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.picImage.TabIndex = 0;
            this.picImage.TabStop = false;
            // 
            // grpReturnInfo
            // 
            this.grpReturnInfo.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpReturnInfo.Controls.Add(this.txtReturnBy);
            this.grpReturnInfo.Controls.Add(this.txtReturnDate);
            this.grpReturnInfo.Controls.Add(this.lblReturnDate);
            this.grpReturnInfo.Controls.Add(this.lblReturnBy);
            this.grpReturnInfo.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpReturnInfo.Location = new System.Drawing.Point(44, -4);
            this.grpReturnInfo.Name = "grpReturnInfo";
            this.grpReturnInfo.Size = new System.Drawing.Size(692, 40);
            this.grpReturnInfo.TabIndex = 2;
            this.grpReturnInfo.TabStop = false;
            // 
            // txtReturnBy
            // 
            this.txtReturnBy.AccessibleDescription = "Returned by";
            this.txtReturnBy.AccessibleName = "Returned by";
            this.txtReturnBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtReturnBy.Location = new System.Drawing.Point(384, 12);
            this.txtReturnBy.Name = "txtReturnBy";
            this.txtReturnBy.ReadOnly = true;
            this.txtReturnBy.Size = new System.Drawing.Size(300, 20);
            this.txtReturnBy.TabIndex = 2;
            // 
            // txtReturnDate
            // 
            this.txtReturnDate.AccessibleDescription = "Return Date";
            this.txtReturnDate.AccessibleName = "Return Date";
            this.txtReturnDate.Location = new System.Drawing.Point(80, 12);
            this.txtReturnDate.Name = "txtReturnDate";
            this.txtReturnDate.ReadOnly = true;
            this.txtReturnDate.Size = new System.Drawing.Size(196, 20);
            this.txtReturnDate.TabIndex = 1;
            // 
            // lblReturnDate
            // 
            this.lblReturnDate.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblReturnDate.Location = new System.Drawing.Point(8, 12);
            this.lblReturnDate.Name = "lblReturnDate";
            this.lblReturnDate.Size = new System.Drawing.Size(72, 20);
            this.lblReturnDate.TabIndex = 0;
            this.lblReturnDate.Text = "Return Date";
            this.lblReturnDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblReturnBy
            // 
            this.lblReturnBy.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblReturnBy.Location = new System.Drawing.Point(308, 12);
            this.lblReturnBy.Name = "lblReturnBy";
            this.lblReturnBy.Size = new System.Drawing.Size(72, 20);
            this.lblReturnBy.TabIndex = 2;
            this.lblReturnBy.Text = "Returned By";
            this.lblReturnBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = null;
            this.btnOK.Location = new System.Drawing.Point(584, 498);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 20;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.CausesValidation = false;
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this.btnCancel.Location = new System.Drawing.Point(664, 498);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 21;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // pnlIssueUnits
            // 
            this.pnlIssueUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlIssueUnits.Controls.Add(this.pnlReturnUnits);
            this.pnlIssueUnits.Controls.Add(this.patientDisplayPanel1);
            this.pnlIssueUnits.Location = new System.Drawing.Point(4, 32);
            this.pnlIssueUnits.Name = "pnlIssueUnits";
            this.pnlIssueUnits.Size = new System.Drawing.Size(736, 460);
            this.pnlIssueUnits.TabIndex = 73;
            this.pnlIssueUnits.VisibleChanged += new System.EventHandler(this.pnlIssueUnits_VisibleChanged);
            // 
            // patientDisplayPanel1
            // 
            this.patientDisplayPanel1.Dock = System.Windows.Forms.DockStyle.Top;
            this.patientDisplayPanel1.EnabledBloodAvailButton = false;
            this.patientDisplayPanel1.EnabledMedicationButton = false;
            this.patientDisplayPanel1.EnabledRecentOrdersButton = false;
            this.patientDisplayPanel1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientDisplayPanel1.EnabledSIAndTRButton = false;
            this.patientDisplayPanel1.EnabledTransfusionReactionHistoryButton = false;
            this.patientDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientDisplayPanel1.Location = new System.Drawing.Point(0, 0);
            this.patientDisplayPanel1.Name = "patientDisplayPanel1";
            this.patientDisplayPanel1.Patient = null;
            this.patientDisplayPanel1.Size = new System.Drawing.Size(736, 44);
            this.patientDisplayPanel1.TabIndex = 0;
            // 
            // patientSelectTool1
            // 
            this.patientSelectTool1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientSelectTool1.DisplaySIAndTRs = true;
            this.patientSelectTool1.EnabledBloodAvailButton = false;
            this.patientSelectTool1.EnabledMedicationButton = false;
            this.patientSelectTool1.EnabledRecentOrdersButton = false;
            this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientSelectTool1.EnabledSIAndTRButton = false;
            this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = false;
            this.patientSelectTool1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientSelectTool1.Location = new System.Drawing.Point(4, 32);
            this.patientSelectTool1.Name = "patientSelectTool1";
            this.patientSelectTool1.SearchVistaLink = false;
            this.patientSelectTool1.Size = new System.Drawing.Size(736, 460);
            this.patientSelectTool1.TabIndex = 0;
            this.patientSelectTool1.PatientSelected += new System.EventHandler(this.patientSelectTool1_PatientSelected);
            this.patientSelectTool1.PatientDeselected += new System.EventHandler(this.patientSelectTool1_PatientDeselected);
            // 
            // worklistBuilder1
            // 
            this.worklistBuilder1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.worklistBuilder1.CheckBoxes = true;
            this.worklistBuilder1.Location = new System.Drawing.Point(4, 36);
            this.worklistBuilder1.Name = "worklistBuilder1";
            this.worklistBuilder1.Size = new System.Drawing.Size(736, 456);
            this.worklistBuilder1.TabIndex = 1;
            this.worklistBuilder1.UnitsInList += new System.EventHandler(this.CheckValid);
            this.worklistBuilder1.ItemCheck += new System.EventHandler(this.worklistBuilder1_ItemCheck);
            this.worklistBuilder1.ValidWorklist += new System.EventHandler(this.CheckValid);
            this.worklistBuilder1.CheckBoxesChanged += new System.EventHandler(this.CheckValid);
            this.worklistBuilder1.InvalidWorklist += new System.EventHandler(this.CheckValid);
            this.worklistBuilder1.SearchClick += new System.EventHandler(this.worklistBuilder1_SearchClick);
            this.worklistBuilder1.SelectBtnClick += new System.EventHandler(this.worklistBuilder1_SelectBtnClick);
            // 
            // FrmReturnIssuedUnits
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(742, 523);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.pnlIssueUnits);
            this.Controls.Add(this.patientSelectTool1);
            this.Controls.Add(this.worklistBuilder1);
            this.hlphelpChm.SetHelpKeyword(this, "Return_Issued_Units_To_Blood_Bank.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(750, 550);
            this.Name = "FrmReturnIssuedUnits";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Return Issued Units";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmReturnIssuedUnits_KeyDownSpeakMessage);
            this.Controls.SetChildIndex(this.worklistBuilder1, 0);
            this.Controls.SetChildIndex(this.patientSelectTool1, 0);
            this.Controls.SetChildIndex(this.pnlIssueUnits, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.pnlReturnUnits.ResumeLayout(false);
            this.groupBox2.ResumeLayout(false);
            this.grpUnitIssueDetails.ResumeLayout(false);
            this.grpUnitIssueDetails.PerformLayout();
            this.grpRemoteStorage.ResumeLayout(false);
            this.grpRemoteStorage.PerformLayout();
            this.grpUnitReturnDetails.ResumeLayout(false);
            this.grpSelectUnits.ResumeLayout(false);
            this.grpImage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).EndInit();
            this.grpReturnInfo.ResumeLayout(false);
            this.grpReturnInfo.PerformLayout();
            this.pnlIssueUnits.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		#region Methods

		/// <summary>
		/// </summary>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC059.FrmReturnIssuedUnits());
			//
			this.btnOK.Text = "&OK";
			//
			// Set all the panels to invisible first and just show what's needed
			this.pnlIssueUnits.Visible = false;
			this.patientDisplayPanel1.Visible = false;
			this.patientSelectTool1.Visible = false;
			this.worklistBuilder1.Visible = false;
			//
			// Set the tooltips of the controls
			this.ttToolTip.SetToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.Cancel().ResString);
			//
			this._issuedUnits = new System.Collections.ArrayList();
		}

		/// <summary>
		/// Sets the screen control data if user is comming from Blood Unit menu
		/// </summary>
		private void SetUnitControlData()
		{
			// Display Worklist builder control first
			this.worklistBuilder1.BringToFront();
			this.worklistBuilder1.Focus();
			this.worklistBuilder1.Visible = true;

			this.pnlIssueUnits.Visible = false;
			this.patientDisplayPanel1.Visible = false;
			this.patientSelectTool1.Visible = false;
		}

		/// <summary>
		/// Sets the screen control data if user is comming from Patient menu
		/// </summary>
		private void SetPatientControlData()
		{
			// Display Patient Select Tool control first
			this.patientSelectTool1.BringToFront();
			this.patientSelectTool1.Focus();
			this.patientSelectTool1.Visible = true;

			this.pnlIssueUnits.Visible = false;
			this.patientDisplayPanel1.Visible = false;
			this.worklistBuilder1.Visible = false;
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>06/08/2002</CreationDate>
		///
		/// <summary>
		/// Private method to display different panels 
		/// </summary>
		private void ProcessFormPanels()
		{
			// Populate Return group
			this.txtReturnDate.Text = this._returnDateTime.ToString();
			this.txtReturnBy.Text = new BOL.VbecsUser(this._returnTechId).UserName;
			
			// If Patient Select Tool was visible, show Return Issued Units panel next
			if(this.patientSelectTool1.Visible)
			{				
				GetIssuedUnitsForPatient();
							
				// No units found in database
				if(this._issuedUnits.Count == 0)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC059.NoUnitsForReturn());
					return;
				}

				//Coming from Patient menu -- nothing is checked by default, so no locks

				this.pnlIssueUnits.Visible = true;
				this.patientDisplayPanel1.Visible = true;
				this.patientDisplayPanel1.Patient = this.patientSelectTool1.SelectedPatient;
				this.patientSelectTool1.Visible = false;
				this.btnOK.EnabledButton = false;

				PopulateIssuedUnitListView();
				//tab order 508 stuff
				this.patientDisplayPanel1.Focus();
			}
				// If Worklist builder control was visible, show Return Issued Units panel next
			else if(this.worklistBuilder1.Visible)
			{
				GetIssuedUnitsForAllPatients();
				
				// No units found in database
				if(this._issuedUnits.Count == 0)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC059.NoUnitsForReturn());
					return;
				}

				//Coming from BloodUnits menu, lock everything....
				foreach (BOL.BloodUnit unit in this.worklistBuilder1.SelectedBloodUnits)
				{
					this.LockController.RecordGuids.Add(unit.BloodUnitStatus.BloodUnitStatusGuid);
				}
				
				foreach (Hashtable ht in this._issuedUnits)
				{
                    this.LockController.RecordGuids.Add((System.Guid)ht[TABLES.IssuedUnit.IssuedUnitGuid]);

					System.Guid orderedUnitGuid = (System.Guid)ht[TABLES.OrderedUnit.OrderedUnitGuid];

					if (orderedUnitGuid != System.Guid.Empty)
					{
                        this.LockController.RecordGuids.Add(orderedUnitGuid);
					}
				}
				//-----------------
	
				if (!this.SetLocks())
				{
					return;
				}

				this.pnlIssueUnits.Visible = true;
				// There is no patient information
				this.patientDisplayPanel1.Visible = false;
				this.worklistBuilder1.Visible = false;
				this.btnOK.EnabledButton = true;
				//
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC059.FrmReturnIssuedUnits_Return());
				//
				PopulateIssuedUnitListView();
				this.txtReturnDate.Focus();
			}
			else if(this.pnlReturnUnits.Visible == true)
			{
				this.SaveSelectedUnits();
				this.txtReturnDate.Focus();
			}
		}

		/// <summary>
		/// Populate return from location combo box.
		/// Defaults to the name of the issue to location.  
		/// </summary>
		private void PopulateReturnedFromLocation()
		{
			// Display BR_59.06
			ArrayList locations =  _currentIssuedUnit.GetLocations();
		
			// Clear exisiting list
			this.cmbReturnFromLocation.Items.Clear();
			
			// Build the locations list
			if (locations.Count > 0) 
			{
				foreach(string location in locations)
				{
					this.cmbReturnFromLocation.Items.Add(location);
				}
			}
		}

		/// <summary>
		/// Gets a list of all issued units that are availabel for selected patient
		/// </summary>
		private void GetIssuedUnitsForPatient()
		{
			this._issuedUnits = BOL.IssuedUnit.GetIssuedUnitsForPatient(this.patientSelectTool1.SelectedPatient.PatientGuid);
		}

		/// <summary>
		/// Gets a list of all issued units that are availabel, if coming from blood unit menu   
		/// </summary>
		private void GetIssuedUnitsForAllPatients()
		{
			// Creates an array of the selected bloodunitguids
			System.Collections.ArrayList tmpArray = new System.Collections.ArrayList();

			foreach(System.Data.DataRow dr in this.worklistBuilder1.SelectedBloodBags.Rows)
			{
				tmpArray.Add((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid]);
			}
			
			this._issuedUnits = BOL.IssuedUnit.GetIssuedUnitsByBloodUnitGuid(tmpArray);	
		}

		/// <summary>
		/// </summary>
		private void PopulateIssuedUnitListView()
		{
			// Clear exisiting list
			this.lvUnitsReturned.Items.Clear();

			// Display all units 
			this.lvUnitsReturned.CheckBoxes = true;
			foreach (Hashtable ht in _issuedUnits)
			{
				this._isLoading = true;
				//
				ListViewItem issuedUnitsList = new ListViewItem();

				issuedUnitsList.SubItems.Add(ht[TABLES.BloodUnit.EyeReadableUnitId].ToString() );
				issuedUnitsList.SubItems.Add(ht[TABLES.BloodProduct.ProductShortName].ToString()+", "+ht[Common.DatabaseConstants.ArtificialColumnNames.FullProductCode].ToString() );
				issuedUnitsList.SubItems.Add(ht[Common.DatabaseConstants.ArtificialColumnNames.ABORh].ToString());
				issuedUnitsList.SubItems.Add(ht[TABLES.BloodUnitMedia.UnitExpirationDate].ToString() );
				// Default Return from location to issued to location
				issuedUnitsList.SubItems.Add(ht[TABLES.IssuedUnit.IssueToLocationName].ToString());
				this.lvUnitsReturned.Items.Add(issuedUnitsList);

				// Create new issued unit object and assing it to tag
				_currentIssuedUnit= new BOL.IssuedUnit((Guid) ht[TABLES.IssuedUnit.IssuedUnitGuid]);

				// Default Return from location to issued to location
				_currentIssuedUnit.ReturnFromLocationName = _currentIssuedUnit.IssueToLocationName;
				// Set return date and tech id
				_currentIssuedUnit.ReturnDateTime = this._returnDateTime;
				_currentIssuedUnit.ReturnTechId = this._returnTechId;
				_currentIssuedUnit.SpecimenExpirationDate = (DateTime) ht[TABLES.PatientSpecimen.SpecimenExpirationDate];
				_currentIssuedUnit.OrderedUnitRowVersion = (byte[]) ht[Common.DatabaseConstants.ArtificialColumnNames.OrderedUnitRowVersion];
				_currentIssuedUnit.OrderedUnitGuid = (Guid) ht[TABLES.OrderedUnit.OrderedUnitGuid];
				_currentIssuedUnit.PatientGuid = (Guid) ht[TABLES.Patient.PatientGuid];
				// Get warning messages for each unit so we can display the info image
				_currentIssuedUnit.SetWarningMessages();
				string messages = _currentIssuedUnit.GetMessagesForTooltip();

				if (messages.Trim().Length > 0)
				{
					issuedUnitsList.ImageIndex = 0;
				}
				
				// If comming from blood unit menu all items are checked by default 
				if(_fromBloodUnitMenu)
				{
					issuedUnitsList.Checked = true;
				}

				issuedUnitsList.Tag = _currentIssuedUnit;
				//
				this._isLoading = false;
			}

			//Set the columns widths
			controls.VbecsFunction.SetColumnWidths(this.lvUnitsReturned);
		}

		/// <summary>
		/// Gets a list of all units that are selected for return by the user and populate the array list
		/// </summary>
		private void GetReturnUnitsList()
		{
			// Displaying BR_59.14 - the system allowes selection for multiple units
			this._returnUnitsList = new System.Collections.ArrayList();
			this._returnUnitsList.Clear();
			//
			foreach (ListViewItem lvItem in this.lvUnitsReturned.CheckedItems)
			{
				// Get return unit info from tag
				_currentIssuedUnit = (BOL.IssuedUnit) lvItem.Tag; 
				_returnUnitsList.Add(_currentIssuedUnit);
			}
		}

		/// <summary>
		///  LoadUnsatisfactoryOverrideComment   
		/// </summary>
		/// 
		/// <returns>
		///     A bool value, true if user entered a comment, or false if decided not to  mark unit as unsatisfactory
		/// </returns>
		private BOL.ExceptionReport LoadUnsatisfactoryOverrideComment()
		{
			// Displaying BR_59.09
			DlgOverrideComment dlg = new DlgOverrideComment(FORM_NAME, "Please enter a comment to mark unit as unsatisfactory", "UR");
			//
            dlg.ShowDialogFromLockedParent(this, false);
			if (dlg.DialogResult== DialogResult.OK)
			{
				BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Unit_unsatisfactory_upon_return, dlg.Comment, Common.LogonUser.LogonUserName);
				exRep.GenerateExceptionReturnIssuedUnit(this._currentIssuedUnit, new BOL.Patient(_currentIssuedUnit.PatientGuid), new BOL.BloodUnit(_currentIssuedUnit.BloodUnitGuid)); 
				dlg.Close();				
				return exRep;
			}
			else
			{
				// User canceled the Override comment window and we will not mark unit as unsatisfactory
				dlg.Close();
				return null;
			}
		}

		
		/// <summary>
		/// Save all units that are selected for return by the user
		/// </summary>
		private void SaveSelectedUnits()
		{
			bool savedResults;

			ArrayList returnUnitExceptions = new System.Collections.ArrayList();

			//
			DialogResult saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC073.UnitsSatisfactory());
			if (saveResult == DialogResult.Yes)
			{
				// Gets a list of all units that are selected for return
				this.GetReturnUnitsList();

				if (this._returnUnitsList.Count > 0)
				{
					try
					{
						//CR 2941
						savedResults = BOL.IssuedUnit.Update(this._returnUnitsList, returnUnitExceptions, this._workloadProcessId, this.patientSelectTool1.SelectedPatient.PatientGuid);
						if (savedResults)
						{
							//CR 1441
							System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) this._workloadProcessId);
							if(dt!= null && _workloadProcessId != Common.WorkloadProcessID.Unknown)
							{
								if(dt.Rows.Count == 0)
								{
									GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
								}
							}
							this.IsDirty = false;
							this.Close();
						}
						else
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved(FORM_NAME));
						}					
					}
					catch(RowVersionException)
					{
						this.btnOK.RowVersionException = true;		//CR2077
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
					}
					
				}
			}
		}

		#endregion

		#region Events / Event Handlers

		/// <summary>
		/// </summary>
		private void pnlIssueUnits_VisibleChanged(object sender, System.EventArgs e)
		{
			if (this.pnlIssueUnits.Visible)
			{
				this.btnOK.Image = controls.VbecsImage.Save.Image;
			}
			else
			{
				this.btnOK.Image = controls.VbecsImage.Transparent.Image;
			}
		}

		/// <summary>
		/// </summary>
		private void cmbReturnFromLocation_Leave(object sender, EventArgs e)
		{
			if (this.cmbReturnFromLocation.SelectedIndex<0)
			{
				cmbReturnFromLocation.Text = this._currentIssuedUnit.ReturnFromLocationName;
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>06/08/2004</CreationDate>
		///
		/// <summary>
		/// Cancel button click event handler, closes the form
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>06/08/2004</CreationDate>
		///
		/// <summary>
		/// OK button click event handler, process the request
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.ProcessFormPanels();
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/8/2004</CreationDate>
		///
		/// <summary>
		/// Patient deselected event handler, disables the OK button and sets tooltip
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>	
		private void patientSelectTool1_PatientDeselected(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = false;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectPatient().ResString);
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/8/2004</CreationDate>
		///
		/// <summary>
		/// Patient selected event handler, enables the OK button and sets tooltip
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void patientSelectTool1_PatientSelected(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = true;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/8/2004</CreationDate>
		/// <summary>
		/// Mouse Hover event handler, displys tooltips
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			// Show tooltip depending what panel is visible. Only available on disabled button
			if (this.btnOK.EnabledButton == false && this.patientSelectTool1.Visible == true)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectPatient().ResString);
			}
			if(this.btnOK.EnabledButton == false && this.pnlIssueUnits.Visible == true)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectUnit().ResString);
			}
            if (this.btnOK.EnabledButton == true)
            {
                this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
            }
		}

		/// <summary>
		/// Blood Unit worklist builder item check event handler, enables OK button
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void worklistBuilder1_ItemCheck(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = (this.worklistBuilder1.SelectedItems > 0);
		}
		
		/// <summary>
		///  Searches for new limited blood units to add to the worklist builder.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e"> Event args</param>
		private void worklistBuilder1_SearchClick(object sender, System.EventArgs e)
		{
			using ( new WaitCursor() ) 
			{
				try
				{
					this.Working();

					// Get a list of valid issued units for this division to prepopulate UC5
					// Displaying BR_59.05
					DataTable eligDt = BOL.IssuedUnit.GetIssuedUnits();
					
					if(eligDt.Rows.Count > 0 )
					{
						// Create a new dialog window and set the required properties...
						DlgSelectBloodUnits unitSelector = new DlgSelectBloodUnits(eligDt, this.worklistBuilder1.bloodUnitSelector1.EnteredEyeReadableUnitId, this.worklistBuilder1.bloodUnitSelector1.EnteredUnitProductCode);
						unitSelector.MultiSelect = true;
						unitSelector.TitleBarText = "VBECS - Select Issued Units for Return";
						unitSelector.LogoBarText = "Select Issued Units for Return to Blood Bank";

                        unitSelector.ShowDialogFromLockedParent(this, false);

						// Don't show unit data if the user cancels
						if( unitSelector.DialogResult == DialogResult.OK )
						{
							if( unitSelector.SelectedUnits.Rows.Count > 1 )
							{
								this.worklistBuilder1.ResetSelectorFieldsAndErrors();
								this._issuedUnitsData = new DataRow [unitSelector.SelectedUnits.Rows.Count];
								this._bloodUnitGuids = new System.Guid [unitSelector.SelectedUnits.Rows.Count];
								int nCtr= 0;
								foreach (DataRow dr in unitSelector.SelectedUnits.Rows)
								{
									System.Guid bloodUnitGuid = (System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid];
									this.worklistBuilder1.PopulateGrid(new BOL.BloodUnit(bloodUnitGuid));
									this._bloodUnitGuids[nCtr] = bloodUnitGuid;
									this._issuedUnitsData[nCtr] = dr;
									nCtr ++;
								}
							}
							else
							{
								if( unitSelector.SelectedUnits.Rows.Count == 1 )
								{
									DataRow dr = unitSelector.SelectedUnits.Rows[0];
									this.worklistBuilder1.bloodUnitSelector1.PopulateSelector(dr[TABLES.BloodUnit.EyeReadableUnitId].ToString(),
										dr[Common.DatabaseConstants.ArtificialColumnNames.FullProductCode].ToString());
								}
							} // end if(unitSelector.SelectedUnits.Rows.Count > 1)
						} // end if( unitSelector.DialogResult == DialogResult.OK )
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.NoValidUnits());
					} // end if(eligDt.Rows.Count > 0 )
				}
				catch (Exception err)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.CannotCreateSearchTool(err.Message));
				}
				finally
				{
					this.Ready();
				}
			}
		}

		/// <summary>
		/// worklist builder select button click event handler. Checks if selected
		/// unit is valid for selection before selecting.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void worklistBuilder1_SelectBtnClick(object sender, System.EventArgs e)
		{
			BOL.BloodUnit unit = this.worklistBuilder1.bloodUnitSelector1.BloodUnit;
			try
			{
				// Displaying message for BR_59.03
				if (unit.BloodUnitStatus.UnitStatusCode.ToString()[0] != Common.Utility.GetUnitStatusCodeCharFromEnum(Common.UnitStatusCode.Issued))
				{
					// Need to throw an Exception to trip up the BloodUnitSelector.  If this
					// isn't done, the unit will appear in the WorkListBuilder ListView. 
					throw new BOL.BusinessObjectException();
				}
			}
			catch(Exception)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC059.UnitNotIssued());
				throw;
			}
		}

		/// <summary>
		/// Worklist Builder IsValid/IsInvalid event handler, enabled OK button.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void CheckValid(object sender, System.EventArgs e)
		{
			btnOK.EnabledButton = (this.worklistBuilder1.SelectedBloodBags.Rows.Count>0);
		}

		/// <summary>
		/// Select Units to return event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void lvUnitsReturned_SelectedIndexChanged(object sender, System.EventArgs e)
		{
	
			ListView lv = (System.Windows.Forms.ListView) sender;
			if (lv.SelectedItems.Count > 0 && this.lvUnitsReturned.CheckBoxes == true)
			{
				ListViewItem lVI = lv.SelectedItems[0];

				this._currentIssuedUnit = (BOL.IssuedUnit) lVI.Tag;
				if(this._currentIssuedUnit.ReturnSatisfactoryIndicator == false)
				{
					this.cbUnsatisfactory.Enabled = false;
					this.cbUnsatisfactory.Checked = true;
					this.cmbReturnFromLocation.Enabled = false;
				}
				else
				{
					this.cbUnsatisfactory.Enabled = true;
					this.cbUnsatisfactory.Checked = false;
					this.cmbReturnFromLocation.Enabled = true;
				}

				// Populate the list of Return from locations
				this.PopulateReturnedFromLocation();

				// Get blood unit object needed to display blood unit detail information 
				BOL.BloodUnit bu = new BOL.BloodUnit( (Guid) this._currentIssuedUnit.BloodUnitGuid); 
				this.bloodUnitDetailsTab1.BloodUnit = bu;

				// Display Unit Issue details
				this.txtIssueDate.Text = this._currentIssuedUnit.IssueDate.ToString();
				this.txtTransporter.Text = this._currentIssuedUnit.TransporterName;
				this.txtLocationName.Text = this._currentIssuedUnit.IssueToLocationName;
				this.txtRemoteStrorage.Text = this._currentIssuedUnit.RemoteStorageText;
				if(this._currentIssuedUnit.ReturnFromLocationName == String.Empty)
				{
					this.cmbReturnFromLocation.Text = this._currentIssuedUnit.IssueToLocationName;
				}
				else
				{
					this.cmbReturnFromLocation.Text = this._currentIssuedUnit.ReturnFromLocationName;
				}
			}
			else
			{
				//lvUnitsReturned.Checkboxes is always going to be true, 
				//so this ELSE block is for lvUnitsReturned.SelectedItems.Count == 0    (CR 2325, CR2326)
				this.bloodUnitDetailsTab1.BloodUnit = null;

				// Reset Unit Issue details
				this.txtIssueDate.Text =String.Empty;
				this.txtTransporter.Text = String.Empty;
				this.txtLocationName.Text = String.Empty;
				this.txtRemoteStrorage.Text = String.Empty;
				this.cmbReturnFromLocation.SelectedIndex = -1;
				this.cbUnsatisfactory.Enabled = false;
				this.cbUnsatisfactory.Checked = false;
				this.cmbReturnFromLocation.Enabled = false;
			}
		}

		/// <summary>
		/// Returned from Location dropdown list event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void cmbReturnFromLocation_SelectedValueChanged(object sender, System.EventArgs e)
		{
			if(!_isLoading)
			{
				if (this.cmbReturnFromLocation.SelectedIndex>-1)
				{
					this._currentIssuedUnit.ReturnFromLocationName = cmbReturnFromLocation.Text;
				
					// Change the text of Return From of the selected item in the list
					this.lvUnitsReturned.SelectedItems[0].SubItems[5].Text = cmbReturnFromLocation.Text;
					this.lvUnitsReturned.SelectedItems[0].Selected = true;
					// Reset the columns widths
					controls.VbecsFunction.SetColumnWidths(this.lvUnitsReturned);
				}
			}
		}

		/// <summary>
		/// Unsatisfactory  for Return checkbox event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void cbUnsatisfactory_CheckedChanged(object sender, System.EventArgs e)
		{
			if (lvUnitsReturned.SelectedItems.Count > 0)
			{
				if (cbUnsatisfactory.Checked && _currentIssuedUnit.ReturnSatisfactoryIndicator == true)
				{
					DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC073.UnitUnsatisfactory());
					if (result == DialogResult.Yes)
					{
						ArrayList returnUnitExceptions = new ArrayList();

						BOL.ExceptionReport exRep = LoadUnsatisfactoryOverrideComment();
						if (exRep != null)
						{
							returnUnitExceptions.Add(exRep);
							//							
							BOL.IssuedUnit issuedUnit = (BOL.IssuedUnit) this.lvUnitsReturned.SelectedItems[0].Tag;
							if (BOL.IssuedUnit.MarkUnitUnsatisfactory(issuedUnit, returnUnitExceptions, Common.WorkloadProcessID.IssueUnit))
							{
								this.lvUnitsReturned.Items.Remove(lvUnitsReturned.SelectedItems[0]);
								this.lvUnitsReturned.Refresh();

								// Reset buttons
								this.cbUnsatisfactory.Enabled = false;
								this.cbUnsatisfactory.Checked = false;
								if (this.lvUnitsReturned.CheckedItems.Count == 0)
								{
									this.btnOK.EnabledButton = false;
									this.IsDirty = false;
								}
							}
						}
						else
						{
							cbUnsatisfactory.Checked = false;
						}
					}
					else
					{
						cbUnsatisfactory.Checked = false;
					}
				}
			}
		}

		/// <summary>
		/// Item check event handler of Select Units for return listview
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void lvUnitsReturned_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (_isLoading == false)
			{
				ListView lv = (ListView) sender;
				ListViewItem lVI = lv.Items[e.Index];
				BOL.IssuedUnit issuedUnit = (BOL.IssuedUnit) lVI.Tag;
				BOL.BloodUnitStatus tmpBUS = new BOL.BloodUnitStatus(issuedUnit.BloodUnitGuid);

				if (e.NewValue == System.Windows.Forms.CheckState.Checked)
				{
					if (!this.SetLocks(issuedUnit.IssuedUnitGuid, issuedUnit.OrderedUnitGuid, tmpBUS.BloodUnitStatusGuid))
					{
						e.NewValue = e.CurrentValue;
						return;
					}
				}

				if ((lv.SelectedItems.Count==0) || (lVI != lv.SelectedItems[0]))
				{
					lVI.Selected = true;
				}

				// ToDo: This can go away
				if (e.NewValue == System.Windows.Forms.CheckState.Unchecked && issuedUnit.ReturnSatisfactoryIndicator == false)
				{
					//Do not allow uncheck unit that has been marked unsatisfactory for return already
					e.NewValue = System.Windows.Forms.CheckState.Checked;
				}
				else
				{
					int ItemsCheckedCount = this.lvUnitsReturned.CheckedItems.Count;
					//
					if (e.NewValue == CheckState.Checked)
					{
						ItemsCheckedCount = this.lvUnitsReturned.CheckedItems.Count + 1;
					}
					else if (e.NewValue == CheckState.Unchecked)
					{
						ItemsCheckedCount = this.lvUnitsReturned.CheckedItems.Count - 1;
					}
				
					//Release locks after above logic,  in case the logic resets the checkstate
					//Dont release the BloodUnitStatusLock, because the way the UC is designed, the user
					//can still Quarrantine the unit if the check-box is unselected
					if (e.NewValue == System.Windows.Forms.CheckState.Unchecked)
					{
						this.ReleaseLocks(issuedUnit.IssuedUnitGuid, issuedUnit.OrderedUnitGuid);
					}

					// Disable or enable the OK button
					if (ItemsCheckedCount == 0)
					{
						this.btnOK.EnabledButton = false;
						this.IsDirty = false;
					}
					else
					{
						this.btnOK.EnabledButton = true;
						this.IsDirty=true;
					}
				}
			}
		}

		/// <summary>
		/// Allows for tooltips on a ListViewItem 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvUnitsReturned_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			ListViewItem lVI = this.lvUnitsReturned.GetItemAt(e.X,e.Y);
			if ( lVI != null && lVI.Tag != null )
			{
				string messages = ((BOL.IssuedUnit)lVI.Tag).GetMessagesForTooltip();

                //CR 3282 Setting tooltip on listview item instead of a listview
			    lVI.ToolTipText = messages;
			} 
		}

		/// <summary>
		/// Sorts the list
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvUnitsReturned_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 4)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvUnitsReturned.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvUnitsReturned.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmReturnIssuedUnits_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if(this.patientSelectTool1.Visible)
			{	
				textToSpeak = this.patientSelectTool1.GetErrorMessagesFor508();
			}
			else if (this.worklistBuilder1.Visible)
			{
				textToSpeak = this.worklistBuilder1.GetErrorMessages();
			}
			else if (this.bloodUnitDetailsTab1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.bloodUnitDetailsTab1.GetErrorMessages());
			}
			else if(this.pnlReturnUnits.Visible == true)
			{
				if (this.btnOK.EnabledButton == false)
				{
					btnOK_MouseHover(sender, e);
					textToSpeak = this.ttToolTip.GetToolTip(this.btnOK);
				}
			}
			if(this.patientDisplayPanel1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.patientDisplayPanel1.GetErrorMessagesFor508());
			}

			if(this.lvUnitsReturned.Visible)
			{
				textToSpeak = string.Concat(textToSpeak,_currentIssuedUnit.GetMessagesForTooltip());
			}

			this.SpeakMessage( textToSpeak );		
		}
		#endregion
	}
}

